;Copyright 1996, 1999  by Henter-Joyce, Inc.
# jfw Scripts for cardfile, 2/18/95, esd
;modified and updated 03/25/99 by j.c

Include "hjconst.jsh"
include "cardfile.jsm"
include "hjglobal.jsh"

GLOBALS
	int CardFileFirst

Void Function AutoStartEvent ()
if (CardFileFirst == 0) then
	let CardFileFirst = 1
	if GetVerbosity() == 0 then
		Say(msg17, ot_help) ;"Use Insert plus H for Jaws Hot Keys and help in dialog boxes with 
	EndIf
EndIf
EndFunction

Script  ScriptFileName()
ScriptAndAppNames ("Cardfile")
EndScript

Script  ReadIndexLine()
var 
	string strIndex
if (GetControlID(GetFocus())!=200 || GlobalMenuMode != MENU_INACTIVE) then 
	return 
endif
InvisibleCursor()
MoveToWindow (GetFocus())
PriorLine()
let strIndex = GetChunk()
if (strIndex == "") then
	let strIndex = msgBlank
endif
if GetVerbosity() == 0 then
	let strIndex = strIndex + msg79 ;" is the Index Line of Card in use"
EndIf
if GetVerbosity() == 1 then
	let strIndex = strIndex + msg80 ;" Index Line"
EndIf
Say(strIndex, ot_message)
PCCursor()
EndScript

Script  SayNumberOfCards()
RouteJawsToPC()
JawsCursor()
JawsPageUP()
NextLine()
NextLine()
JawsEnd()
PriorWord()
SayFromCursor()
if GetVerbosity() == 0 then
	Say(msg81, ot_message) ;"in this file"
EndIf
PCCursor()
EndScript

Script  PreviousCard()
if (!IsPCCursor()) then
	Say(msg91, ot_message); "Page up"
	JAWSPageUp()
	return
endif
{PageUp}
delay (1)
if GetVerbosity() == 0 then
Say(msg82, ot_message) ;"Previous Card"
EndIf
PerformScript ReadIndexLine()
EndScript

Script  NextCard()
if (!IsPCCursor()) then
	Say(msg92, ot_message); "Page down"
	JAWSPageDown()
	return
endif
{PageDown}
delay (1)
if GetVerbosity() == 0 then
Say(msg83, ot_message) ;"Next Card"
EndIf
PerformScript ReadIndexLine()
EndScript

Script  FirstCard()
{Control+Home}
delay (1)
if GetVerbosity() == 0 then
Say(msg84, ot_message) ;"First Card in file"
EndIf
PerformScript ReadIndexLine()
EndScript

Script  LastCard()
{Control+End}
delay (1)
if GetVerbosity() == 0 then
Say(msg85, ot_message) ;"Last Card in file"
EndIf
PerformScript ReadIndexLine()
EndScript

Script  WindowKeysHelp()
Say(msg86, ot_help) ;"You can use the following windows shortcuts in Cardfile"
Say(msg87, ot_help) ;"to create a new card use F7"
Say(msg88, ot_help) ;"to change index line of current card use F6"
Say(msg89, ot_help) ;"to search cards via index line use F4"
Say(msg90, ot_help) ;"to use autodial use F5"
EndScript

Script  HotKeyHelp()
;wn6="Go To"
if (GetWindowName (GetRealWindow (GetFocus())) == wn6) then
	Say(msg21, ot_help) ;"Type in a portion of the index line for the card you want and press enter"
	Say(msg22 + GetScriptKeyName ("readindexline"), ot_help) ;"use Alt I to check to see if you found the right card"
	Say(msg23, ot_help)  ;"if not please try again with more specific information for the index line"
	Return
EndIf
;wn24="Find"
if (GetWindowName (GetRealWindow (GetFocus())) == wn24) then
	Say(msg25, ot_help) ;"Type in some text which appears in the data section of the card you want"
	Say(msg26, ot_help) ;"After pressing enter, if you do not get an error message, then press escape"
	Say(msg27, ot_help) ;"the text found will be highlighted and the cursor will be on the right side"
	Say(msg28, ot_help) ;"check the index line of the card you found"
	Say(msg29, ot_help) ;"you can use F3 to find next occurrence of text if you choose"
	Say(msg30, ot_help) ;"Other options in Find Dialog include a match case check box"
	Say(msg31, ot_help) ;"and a direction search up or down through the file option"
	Return
EndIf
;wn15="Add"
if (GetWindowName (GetRealWindow (GetFocus())) == wn15) then
	Say(msg32 + msg33, ot_help) ;" index line of this new card and press enter"
	Say(msg34 + msg35, ot_help) ;" later you can use the F6 index feature"
	Return
EndIf
;wn12="Index"
if (GetWindowName (GetRealWindow (GetFocus())) == wn12) then
	Say(msg36 + msg37, ot_help) ;" the index line of this card and press enter"
	Say(msg38 + msg39, ot_help) ;" index line of existing cards only"
	Say(msg40, ot_help) ;"using the F7 add feature will create index lines of new cards"
	Return
EndIf
;wn9="Autodial"
if (GetWindowName (GetRealWindow (GetFocus())) == wn9) then
	Say(msg41, ot_help) ;"the first field contains the number to be dialed"
	Say(msg42, ot_help) ;"tab once to confirm or change prefix"
	Say(msg43, ot_help) ;"tab again to check or uncheck the prefix checkbox"
	Say(msg44, ot_help) ;"tab to setup button and enter or use Alt S to select modem settings"
	Return
EndIf
;wn45="Open"
if (GetWindowName (GetRealWindow (GetFocus())) == wn45) then
	Say(msg46, ot_help) ;"you can type in a path and file name then enter or"
	Say(msg47 + msg48, ot_help) ;" or jump using the following Windows hot keys"
	Say(msg49, ot_help) ;"For the list of disk drives, use Alt V then type the drive letter"
	Say(msg50, ot_help) ;"To select the path use Alt D for the directories list box"
	Say(msg51, ot_help) ;"Now type the first letter for each directory or subdirectory"
	Say(msg52, ot_help) ;"To choose the type of files you are looking for, Use Alt T"
	Say(msg53, ot_help) ;"Now arrow thru the list to find your choice"
	Say(msg54 + msg55, ot_help) ;" and type in a name or tab to list box"
	Say(msg56, ot_help) ;"Now you can type the first letter of the file you want and then enter"
	Say(msg57, ot_help) ;"Use escape to cancel"
	Return
EndIf
;wn58="Save As"
if (GetWindowName (GetRealWindow (GetFocus())) == wn58) then
	Say(msg59, ot_help) ;"type in a path and file name then enter or"
	Say(msg60 + msg61, ot_help) ;" jump using the following Windows hot keys"
	Say(msg49, ot_help) ;"For the list of disk drives, use Alt V then type the drive letter"
	Say(msg50, ot_help) ;"To select the path use Alt D for the directories list box"
	Say(msg51, ot_help) ;"Now type the first letter for each directory or subdirectory"
	Say(msg62, ot_help) ;"To choose the file type you would like to save it as, Use Alt T"
	Say(msg63, ot_help) ;"Use the down arrow and find your choice"
	Say(msg64, ot_help) ;"Use Alt N to return to File Name edit box and type in a name"
	Say(msg57, ot_help) ;"Use escape to cancel"
	Return
EndIf
;wn65="File Merge"
if (GetWindowName (GetRealWindow (GetFocus())) == wn65) then
	Say(msg66, ot_help) ;"This box is set up just like a file Open Dialog box"
	Say(msg67, ot_help) ;"there are file name and directories list boxes"
	Say(msg68, ot_help) ;"along with drives and list files of types combo boxes"
	Say(msg69, ot_help) ;"You should go into Cardfile help for more information on this subject"
	Return
EndIf
If (GetWindowTypeCode (GetRealWindow(GetFocus ())) ==	WT_DIALOG) then
	HotKeyHelpDefaultLoop ()
Else
Say(msg70, ot_help) ;"Once you have opened a file"
Say(msg71 + GetScriptKeyName ("readindexline"), ot_help) ;"Use Alt plus the letter I to reed the index line"
Say(msg72 + GetScriptKeyName ("saynumberofcards"), ot_help) ;"Use Alt plus the letter Q to reed the quantity of cards in file"
Say(msg73, ot_help) ;"To create a file of cards, go through the menus"
Say(msg74, ot_help) ;"Or Press F1 for help to get started"
Say(msg75, ot_help)  ;"A helpful hint to remember when entering information in cards"
Say(msg76 + msg77, ot_help) ;" on the first line if you plan to use autodial"
Say(msg78 + GetScriptKeyName ("WindowKeysHelp"), ot_help) ;"You can also use Insert plus W for Windows hot keys in Cardfile"
EndIf
EndScript

Script  RepeatLastSearch()
;insures that the edit window is active
;wc1="Edit"
if ((GetCurrentControlID ()==200) && (GetWindowClass (GetCurrentWindow ())==wc1)) Then 
	{F3}
	If (GetVerbosity ()== 0) Then 
		Say(msg3, ot_message) ;"repeating prior search"
	EndIf ; end verbosity check
Else 
	If (GetVerbosity ()== 0) Then 
		Say(msg4, ot_message) ;"Cannot repeat a search now"
	Else 
		Beep ()
	EndIf ; ends verbosity check
	PerformScript HotKeyHelp(); runs the context sensitive help
EndIf ; ends location check
EndScript

Script  LaunchGoTo()
;insures that the edit window is active
;wc1="Edit"
if ((GetCurrentControlID ()==200) && (GetWindowClass (GetCurrentWindow ())==wc1)) Then 
	{F4}
	If (GetVerbosity ()== 0) Then 
		Say(msg5, ot_message) ;"go to a specific card"
	EndIf ; end verbosity check
Else 
	; tests for the go to window
	;wn6="Go To"
	if (GetWindowName (GetRealWindow (GetFocus())) != wn6) then
		If (GetVerbosity ()== 0) Then 
			Say(msg7, ot_message) ;"Cannot go to a card now"
		Else 
			Beep ()
		EndIf ; ends verbosity check
	EndIf ; ends window test 
	PerformScript HotKeyHelp(); runs the context sensitive help
EndIf ; ends location check
EndScript
	
Script  DoDial()
;insures that the edit window is active
;wc1="Edit"
if ((GetCurrentControlID ()==200) && (GetWindowClass (GetCurrentWindow ())==wc1)) Then 
	{F5}
	If (GetVerbosity ()== 0) Then 
		Say(msg8, ot_message) ;"dialing the phone number"
	EndIf ; end verbosity check
Else 
	; checks for the dialing dialog box
	;wn9="Autodial"
	if (GetWindowName (GetRealWindow (GetFocus())) != wn9) then
		If (GetVerbosity ()== 0) Then 
			Say(msg10, ot_help) ;"Cannot dial a number  now"
		Else 
			Beep ()
		EndIf ; ends verbosity check
	endif ; ends window test 
	PerformScript HotKeyHelp (); runs the context sensitive help
EndIf ; ends location check
EndScript

Script  OpenExistingIndexLine()
;insures that the edit window is active
;wc1="Edit"
if ((GetCurrentControlID ()==200) && (GetWindowClass (GetCurrentWindow ())==wc1)) Then 
	{F6}
	If (GetVerbosity ()== 0) Then 
		Say(msg11, ot_message) ;"Opening an existing index line"
	EndIf ; end verbosity check
Else 
	; tests for the index window
	;wn12="Index"
	if (GetWindowName (GetRealWindow (GetFocus())) != wn12) then
		If (GetVerbosity ()== 0) Then 
			Say(msg13, ot_message) ;"Cannot open an index line now"
		Else 
			Beep ()
		EndIf ; ends verbosity check
	EndIf ; ends window test
	PerformScript hotkeyhelp (); runs the context sensitive help
EndIf ; ends location check
EndScript

Script  OpenNewCard()
;insures that the edit window is active
;wc1="Edit"
if ((GetCurrentControlID ()==200) && (GetWindowClass (GetCurrentWindow ())==wc1)) Then 
	{F7}
	If (GetVerbosity ()== 0) Then 
		Say(msg14, ot_message) ;"adding a new card"
	EndIf ; end verbosity check
Else 
	; tests for add card window 
	;wn15="Add"
	if (GetWindowName (GetRealWindow (GetFocus())) != wn15) then
		If (GetVerbosity ()== 0) Then 
			Say(msg16, ot_message) ;"Cannot add a new card now"
		Else 
			Beep ()
		EndIf ; ends verbosity check
	EndIf ; ends window test
	PerformScript hotkeyhelp (); runs the context sensitive help
EndIf ; ends location check
EndScript
